<?php 
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/util.php";
    include "../include/costanti.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/Cartella.php";
    include "../classi/Contenuto.php";
    include "../classi/GestoreStoricoOperazioni.php";
    include "../classi/GeneratoreUrl.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $gestoreStoricoOperazioni = new GestoreStoricoOperazioni($geecomDb,"Doc");
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecD_impostazioni", 1);
    
    session_start();
    controlloAccessoAdmin();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $cartella = new Cartella($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $cartella = new Cartella($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 3) ;
    $percorsoGeecomDoc = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'crea':
            $cartella->setCartellaMadre(filter_input(INPUT_POST,"cartellaMadre",FILTER_SANITIZE_NUMBER_INT));
            $cartella->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $cartella->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $idCartella = $cartella->crea();
            if($idCartella>0) {
                echo "ok";
                $gestoreStoricoOperazioni->aggiungiElemento("creazioneCartella", $_SESSION["geecomAdmin_nome"]." ha creato una nuova cartella");
            }
            else {
                echo "Errore, esiste già una cartella con questo nome";
            }
            break;
        case 'modifica':
            $cartella->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $cartella->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $cartella->modifica();
            header("Location: $percorsoGeecomDoc/dettagliCartella.php?id={$cartella->getId()}&status=200");
            break;
        case 'rinomina':
            $cartella->setNome(filter_input(INPUT_POST,"nuovoNome",FILTER_SANITIZE_ADD_SLASHES));
            $cartella->rinomina();
            echo "ok";
            break;
        case 'sposta':
            $cartella->sposta(filter_input(INPUT_POST,"idCartella",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'spostaElementiSelezionati':
            $cartella->spostaSelezionati(filter_input(INPUT_POST,"idCartella",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST,"stringaIdCartelle",FILTER_SANITIZE_ADD_SLASHES),filter_input(INPUT_POST,"stringaIdDocumenti",FILTER_SANITIZE_ADD_SLASHES));
            echo "ok";
            break;
        case 'spostaContenuto':
            $cartella->spostaContenuto(filter_input(INPUT_POST,"idCartella",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'elimina':
            $cartella->elimina();
            $cartella->eliminaContenuto();
            echo "ok";
            break;
        case 'eliminaSelezionati':
            $cartella->eliminaSelezionati(filter_input(INPUT_POST,"stringaIdCartelle",FILTER_SANITIZE_ADD_SLASHES),filter_input(INPUT_POST,"stringaIdDocumenti",FILTER_SANITIZE_ADD_SLASHES));
            echo "ok";
            break;
        case 'eliminaContenuto':
            $cartella->eliminaContenuto();
            echo "ok";
            break;
        case 'aggiungiAiPreferiti':
            $cartella->aggiungiAiPreferiti(filter_input(INPUT_POST,"idUtente",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'rimuoviDaiPreferiti':
            $cartella->rimuoviDaiPreferiti(filter_input(INPUT_POST,"idUtente",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'stampaContenutoCartella':
            $cartella->stampaContenutoCartella(false,filter_input(INPUT_POST,"cerca",FILTER_SANITIZE_ADD_SLASHES));
            break;
        case 'stampaAlberoCartella':
            $cartella->caricaDatiDalDatabase();
            $arrayCartelleMadri = ($cartella->getCartellaMadre()>0) ? $cartella->arrayCartelleMadri() : [];
            $datiCartellaRadice = $geecomDb->leggiSingolaRiga("geecD_cartelleRadice",$_SESSION["geecomAdmin_id"],"idUtente");

            $cartellaRadice = new Cartella($geecomDb, $datiCartellaRadice["idCartella"]);
            $cartellaRadice->caricaDatiDalDatabase();
            
            // se è una sottocartella di template l'albero della cartella radice deve stare chiuso
            if($cartella->cartellaTemplate()) {
                $cartellaRadice->alberoCartella(0,false);
            }
            else {
                $cartellaRadice->alberoCartella($cartella->getId(),true,$arrayCartelleMadri);
            }

            if($_SESSION["geecomAdmin_ruolo"]=="super admin") {
                $cartellaRadice->alberoCartellaTemplate($cartella->cartellaTemplate(),$cartella->getId(),$arrayCartelleMadri);
            }
            break;
        case 'stampaCartellePreferite':
            $query       = "SELECT c.* FROM geecD_cartellePreferite AS cp JOIN geecD_cartelle AS c ON cp.idCartella = c.id WHERE idUtente = {$_SESSION["geecomAdmin_id"]}";
            $risCartelle = $geecomDb->eseguiQueryLettura($query);

            while($cartellaPreferita = $risCartelle->fetch_assoc()) {
                stampaCartella($geecomDb, $cartellaPreferita,true,true);
            }
            break;
        case 'caricaElementiModalSpostamento':
            $cartella->caricaDatiDalDatabase();
            stampaElementiPerModalSpostamento($geecomDb,filter_input(INPUT_POST,"tipoModal",FILTER_SANITIZE_ADD_SLASHES),$cartella);
            break;
        case 'stampaBreadcrumbModalSpostamento':
            $cartella->caricaDatiDalDatabase();
            $cartella->stampaBreadcrumbCartellaModalSpostamento(filter_input(INPUT_POST,"tipoModal",FILTER_SANITIZE_ADD_SLASHES));
            break;
        case 'creaPaginaCondivisione':
            include "../".$datiProdottoGeecom["percorso"]."/componenti/condivisioneFile/classi/CondivisioniFile.php";
            $cartella->caricaDatiDalDatabase();
            $titolo    = "Pagina condivisione della cartella ".$cartella->getNome();
            $contenuto = new Contenuto($geecomDb, 0);
            
            $contenuto->setTitolo($titolo);
            $contenuto->setMostraTitolo("no");
            $contenuto->setAlias($contenuto->generaAlias($titolo));
            $contenuto->setTipo("pagina");
            $contenuto->setPrivato("no");
            $contenuto->setStato("pubblicato");
            $contenuto->setLingua("italiano");
            $contenuto->setTemplate("templateBase.php");
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_STRING));
            $contenuto->setAutore($_SESSION["geecomAdmin_nomeCognome"]);
            $datiAnalisiSEO = $contenuto->eseguiAnalisiSeo();
            $contenuto->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            $idContenuto = $contenuto->crea();
            
            $condivisioneFile = new CondivisioniFile($geecomDb, filter_input(INPUT_GET, "id"));
            $condivisioneFile->setNome("Approvazione cartella ".$cartella->getNome());
            $condivisioneFile->setCartellaDaCondividere($cartella->getId());
            $condivisioneFile->setDestinatari(filter_input(INPUT_POST,"destinatariApprovazione",FILTER_SANITIZE_STRING));
            $condivisioneFile->setTesto(filter_input(INPUT_POST,"testoApprovazione",FILTER_SANITIZE_STRING));
            $condivisioneFile->setTermineCondivisione(filter_input(INPUT_POST,"termineCondivisione",FILTER_SANITIZE_STRING));
            $idComponenteCondivisione = $condivisioneFile->crea();
            $contenuto->caricaDatiDalDatabase();
            
            $linkContenuto = GeneratoreUrl::creaUrlContenuto($contenuto->getDatiContenuto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
            ?>
                Pagina convivisione creata, ecco il link:<br>
                <a href="<?= $linkContenuto ?>"><?= $linkContenuto ?></a>
                <p class="mt-3"><b>Ricorda che puoi modificare la pagina generata nella sezione pagine</b></p>
            <?php
            
            $queryInserimentoOccorenza = "INSERT INTO `geecD_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'25',$idContenuto,'contenuto',$idComponenteCondivisione,1,'sezione$idComponenteCondivisione')";
            $geecomDb->eseguiQueryScrittura($queryInserimentoOccorenza);
            break;
        case 'creaPaginaApprovazione':
            
            include "../".$datiProdottoGeecom["percorso"]."/componenti/approvazioneFile/classi/ApprovazioneFile.php";
            $cartella->caricaDatiDalDatabase();
            $titolo    = "Pagina approvazione della cartella ".$cartella->getNome();
            $contenuto = new Contenuto($geecomDb, 0);
            
            $contenuto->setTitolo($titolo);
            $contenuto->setMostraTitolo("no");
            $contenuto->setAlias($contenuto->generaAlias($titolo));
            $contenuto->setTipo("pagina");
            $contenuto->setPrivato("no");
            $contenuto->setStato("pubblicato");
            $contenuto->setLingua("italiano");
            $contenuto->setTemplate("templateBase.php");
            $contenuto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_STRING));
            $contenuto->setAutore($_SESSION["geecomAdmin_nomeCognome"]);
            $datiAnalisiSEO = $contenuto->eseguiAnalisiSeo();
            $contenuto->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            $idContenuto = $contenuto->crea();
            
            $approvazioneFile = new ApprovazioneFile($geecomDb, filter_input(INPUT_GET, "id"));
            $approvazioneFile->setNome("Approvazione cartella ".$cartella->getNome());
            $approvazioneFile->setCartellaDaApprovare($cartella->getId());
            $approvazioneFile->setDestinatari(filter_input(INPUT_POST,"destinatariApprovazione",FILTER_SANITIZE_STRING));
            $approvazioneFile->setTesto(filter_input(INPUT_POST,"testoApprovazione",FILTER_SANITIZE_STRING));
            $approvazioneFile->setTermineApprovazione(filter_input(INPUT_POST,"termineApprovazione",FILTER_SANITIZE_STRING));
            $idComponenteApprovazione = $approvazioneFile->crea();
            $contenuto->caricaDatiDalDatabase();
            
            $linkContenuto = GeneratoreUrl::creaUrlContenuto($contenuto->getDatiContenuto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
            ?>
                Pagina approvazione creata, ecco il link:<br>
                <a href="<?= $linkContenuto ?>"><?= $linkContenuto ?></a>
                <p class="mt-3"><b>Ricorda che puoi modificare la pagina generata nella sezione pagine</b></p>
            <?php
            
            $queryInserimentoOccorenza = "INSERT INTO `geecD_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'26',$idContenuto,'contenuto',$idComponenteApprovazione,1,'sezione$idComponenteApprovazione')";
            $geecomDb->eseguiQueryScrittura($queryInserimentoOccorenza);
            break;
    }